@replaceMethod(PreventionSystem) //This function made all npc's attack player
  private final func WakeUpAllAgents(wakeUp: Bool) -> Void {
	return;
	};

@addField(VehicleObject)
let vcDriverValid: Bool;

//Make police quickhackable
@replaceMethod(ScriptedPuppet)
  public const func IsQuickHackAble() -> Bool {
    let actionRecords: array<wref<ObjectAction_Record>>;
    let i: Int32;
    if !this.IsActive() {
      return false;
    };
    if this.IsCrowd() {
      return false;
    };
	/*
    if this.IsPrevention() {
      return false;
    };
	*/
    if !this.IsAggressive() {
      return false;
    };
    if QuickhackModule.IsQuickhackBlockedByScene(Device.GetPlayerMainObjectStatic(this.GetGame())) {
      return false;
    };
    if this.GetRecord().GetObjectActionsCount() <= 0 {
      return false;
    };
    if !EquipmentSystem.IsCyberdeckEquipped(Device.GetPlayerMainObjectStatic(this.GetGame())) {
      return false;
    };
    this.GetRecord().ObjectActions(actionRecords);
    i = 0;
    while i < ArraySize(actionRecords) {
      if Equals(actionRecords[i].ObjectActionType().Type(), gamedataObjectActionType.PuppetQuickHack) {
        return true;
      };
      i += 1;
    };
    return false;
  }


//Disable security turrets locking onto corpos
@wrapMethod(SecurityTurret)
  protected cb func OnTargetLocked(evt: ref<TargetLockedEvent>) -> Bool {
  
	if IsHost(){
		if this.GetDevicePS().IsBroken(){
			return false;
		};
		let targetFaction: String = (this.GetCurrentlyFollowedTarget() as NPCPuppet).GetAffiliation();
		switch targetFaction{
			case "NCPD":
			case "TraumaTeam":
			case "Arasaka":
			case "Militech":
			case "KangTao":
			case "Biotechnica":
			case "SouthCalifornia":
				return false;
			break;
		};
			
		
	};
	wrappedMethod(evt);
  }
  
//Make the turrets attack all targets and not just V
@replaceMethod(SenseComponent)
 protected cb func OnSenseInitialize(evt: ref<SenseInitializeEvent>) -> Bool {
    let puppet: wref<ScriptedPuppet>;
    let sensorDevice: wref<SensorDevice> = this.GetEntity() as SensorDevice;
    if IsDefined(sensorDevice) && (sensorDevice.GetDevicePS() as SensorDeviceControllerPS).IsPartOfPrevention() {
      if sensorDevice.GetPreventionSystem().AreTurretsActive() {
        this.CreateSenseMappin();
		let attitudeOwner: ref<AttitudeAgent> = sensorDevice.GetAttitudeAgent(); //Make the turrets blast everyone
		attitudeOwner.SetAttitudeGroup(n"hostile");
      };
    } else {
      this.CreateSenseMappin();
    };
    puppet = this.GetOwnerPuppet();
    if IsDefined(puppet) {
      this.m_mainPreset = TDBID.Create("Senses." + (this.GetEntity() as ScriptedPuppet).GetStringFromCharacterTweak("relaxedSensesPreset", "Relaxed"));
      this.m_puppetBlackboard = puppet.GetPuppetStateBlackboard();
      if IsDefined(this.m_puppetBlackboard) {
        this.m_highLevelCb = this.m_puppetBlackboard.RegisterListenerInt(GetAllBlackboardDefs().PuppetState.HighLevel, this, n"OnHighLevelChanged");
        this.m_reactionCb = this.m_puppetBlackboard.RegisterListenerInt(GetAllBlackboardDefs().PuppetState.ReactionBehavior, this, n"OnReactionChanged");
      };
    };
  }


//Set our prevention agents to hostile so they'll attack other enemies and not just V
@wrapMethod(ReactionManagerComponent)
    protected cb func OnDetectedEvent(evt: ref<OnDetectedEvent>) -> Bool {
	
	//Make our police get modified madness on spawn to ensure they attack other targets and not just V
	if NPCManager.HasTag(this.GetOwnerPuppet().GetRecordID(), n"Prevention"){
		let attitudeOwner: ref<AttitudeAgent> = this.GetOwnerPuppet().GetAttitudeAgent();
		attitudeOwner.SetAttitudeGroup(n"hostile");
		

	};
	
	wrappedMethod(evt);
}

//Reset vcDriver variable when driver has got in and started chasing someone
@replaceMethod(InVehicleCombatDecorator)
  protected final func ChaseNewTarget(context: ScriptExecutionContext, newTarget: wref<GameObject>) -> Void {
    let command: ref<AIVehicleFollowCommand> = new AIVehicleFollowCommand();
    command.target = newTarget;
    command.stopWhenTargetReached = false;
    command.distanceMin = 5.00;
    command.distanceMax = 6.00;
    command.useTraffic = false;
    command.needDriver = true;
    if this.SendAICommandToMountedVehicle(context, command) {
		let vehicle: wref<VehicleObject>;
		if VehicleComponent.GetVehicle(ScriptExecutionContext.GetOwner(context).GetGame(), ScriptExecutionContext.GetOwner(context), vehicle){
			vehicle.vcDriverValid = false;
		};
	
      this.targetToChase = newTarget;
    };
  }
  
//Used for getting our prevention units back into their vehicles when V gets back in theirs
@addMethod(AIActionTarget)
public static func TryMountVehicle(owner: wref<ScriptedPuppet>, context: ScriptExecutionContext, maxDistance: Float) -> Void{
	let evt: ref<MountAIEvent>;
	let mountData: ref<MountEventData>;
	let vehicleID: EntityID;
	let vehicleSlotID: MountingSlotId;
	let vehicleSlot: CName;
	let vehiclePosition: Vector4;
	let vehicle: wref<VehicleObject>;
	let driver: wref<ScriptedPuppet>;
	if !AIBehaviorScriptBase.GetAIComponent(context).GetAssignedVehicleData(vehicleID, vehicleSlotID) {
	  return;
	};
	
	
	if VehicleComponent.IsSlotOccupied(owner.GetGame(), vehicleID, vehicleSlotID) {
	  return;
	};
	

	driver = VehicleComponent.GetDriver(owner.GetGame(), vehicleID) as ScriptedPuppet;
	
	
	vehicle = GameInstance.FindEntityByID(owner.GetGame(), vehicleID) as VehicleObject;
	vehicleSlot = vehicleSlotID.id;
	
	//Don't mount if the player's in there lmao
	if vehicle.IsPlayerMounted(){
		return;
	};
	
	//Don't try and get in a moving vehicle
	if vehicle.GetBlackboard().GetFloat(GetAllBlackboardDefs().Vehicle.SpeedValue) > 0.5{
		return;
	};

	//If our driver is incompatible, then they still count as the driver. So we need a new one.
	if (driver.IsIncapacitated() || (Vector4.Distance(driver.GetWorldPosition(), vehicle.GetWorldPosition()) > maxDistance)) && !vehicle.vcDriverValid {
		vehicleSlot = n"seat_front_left";
		vehicle.vcDriverValid = true;
	};
	
	mountData = new MountEventData();
	mountData.slotName = vehicleSlot;
	mountData.mountParentEntityId = vehicleID;
	mountData.isInstant = false;
	mountData.ignoreHLS = true;
	evt = new MountAIEvent();
	evt.name = n"Mount";
	evt.data = mountData;
	ScriptExecutionContext.GetOwner(context).QueueEvent(evt);
	
}

@addField(ScriptedPuppet)
let VCNotMovingCount: Int32;

//AI Stuff
@wrapMethod(AIActionTarget)
  private final static func RegularThreatCalculation(owner: wref<ScriptedPuppet>, ownerPos: Vector4, targetTrackerComponent: ref<TargetTrackerComponent>, newTargetObject: wref<GameObject>, threat: wref<GameObject>, timeSinceTargetChange: Float, currentTime: Float, out threatValue: Float) -> Void {
  
	//If we're using one of our spawned agents, use some custom threat calculations. Also used to let them remount vehicles
	if NPCManager.HasTag(owner.GetRecordID(), n"Prevention"){
	
	
		if owner.GetAIControllerComponent().HasVehicleAssigned(){
		
		//Try to mount a vehicle if they left theirs
				let vehicleMountingConditions: array<wref<AIActionSubCondition_Record>>;
				let context: ScriptExecutionContext;
				let threatPos: Vector4 = threat.GetWorldPosition();
				let vehicle: wref<VehicleObject>;
				let maxDistance: Float = -1.00;
				AIHumanComponent.GetScriptContext(owner, context);
				TweakDBInterface.GetAIActionANDRecord(t"Condition.MountVehicleInCombatCondition").AND(vehicleMountingConditions);
				AIHumanComponent.GetAssignedVehicle(owner, vehicle);
				let vehiclePos: Vector4 = vehicle.GetWorldPosition();
				
			if threat.IsPlayer(){

				//Check for all of our conditions (mostly distance, and if the target is in a vehicle)
				if Vector4.Distance(ownerPos, threatPos) > 30.0 && Vector4.Distance(ownerPos, vehiclePos) < 12.0{
					maxDistance = 12.0;
				};
				if Vector4.Distance(ownerPos, threatPos) > 60.0 && Vector4.Distance(ownerPos, vehiclePos) < 25.0 {
					maxDistance = 25.0;
				};
				
				if maxDistance != -1.00{
					if AICondition.Check(context, vehicleMountingConditions[10] as AIVehicleCond_Record){
						if AICondition.Check(context, vehicleMountingConditions[3] as AITargetCond_Record){
							if AICondition.Check(context, vehicleMountingConditions[4] as AISquadCond_Record){
								if AICondition.Check(context, vehicleMountingConditions[5] as AICommandCond_Record){
									if AICondition.Check(context, vehicleMountingConditions[6] as AICommandCond_Record){
										if AICondition.Check(context, vehicleMountingConditions[7] as AICommandCond_Record){
											if AICondition.Check(context, vehicleMountingConditions[11] as AITargetCond_Record){
												AIActionTarget.TryMountVehicle(owner, context, maxDistance);
											}
										}
									}
								}
							}
						}
					}
				}
			
			
				//Try to dismount their vehicle if they are stuck

				let vehSpeed: Float = vehicle.GetBlackboard().GetFloat(GetAllBlackboardDefs().Vehicle.SpeedValue);
				if vehSpeed < 0.5 && vehSpeed > -0.5 {
					owner.VCNotMovingCount +=1;
					//If we haven't moved in X updates, then unmount the vehicle
					if owner.VCNotMovingCount > TweakDBInterface.GetInt(t"VC.StaticVehicleUnmountLimit", 10){
						let workspotSystem: ref<WorkspotGameSystem>;
						workspotSystem = GameInstance.GetWorkspotSystem(owner.GetGame());
						if IsDefined(workspotSystem) {
							let defaultOrientation: Quaternion = owner.GetWorldOrientation();
							let defaultVector: Vector4;
							let unmountDist: Vector4;
							let unmountForward: Vector4 = vehicle.GetWorldForward();

							unmountDist = unmountForward * TweakDBInterface.GetFloat(t"VCUnmountingDistance", 1);
							unmountDist.W = 1;
							defaultVector.X = 0;
							defaultVector.Y = 0;
							defaultVector.Z = 0;
							defaultVector.W = 1;
							owner.VCNotMovingCount = 0;

							if Equals(owner.GetHighLevelStateFromBlackboard(), gamedataNPCHighLevelState.Combat) {
							  workspotSystem.UnmountFromVehicle(vehicle, owner, false, unmountDist, defaultOrientation, n"default"); //Use default instead of combat exiting because the combat exiting can make NPC's get out in middle of vehicle
							} else {

								workspotSystem.UnmountFromVehicle(vehicle, owner, false, defaultVector, defaultOrientation, n"default");

							};
						};
					};
				}
				else{
					owner.VCNotMovingCount = 0;
				};

			};
		};
		
		//Make prevention NPC's attack other factions
		let distance: Float;
		let turret: wref<SecurityTurret>;
		let zDiff: Float;
		if ScriptedPuppet.IsActive(threat) {
		
		  
		  threatValue = 20.0;	//Base threat value for NPC's
		  
		  //Get the factions
		  //If they're both corpos, they won't attack each other
		  let corpoFactions:array<String>;
		  let ownerCorpo: Bool =false;
		  let threatCorpo: Bool = false;
		  let ownerFaction: String = (owner as NPCPuppet).GetAffiliation();
		  let threatFaction: String = (threat as NPCPuppet).GetAffiliation();
		  ArrayPush(corpoFactions, "NCPD");
		  ArrayPush(corpoFactions, "TraumaTeam");
		  ArrayPush(corpoFactions, "SouthCalifornia");
		  ArrayPush(corpoFactions, "Arasaka");
		  ArrayPush(corpoFactions, "Biotechnica");
		  ArrayPush(corpoFactions, "Militech");
		  ArrayPush(corpoFactions, "KangTao");
		  ArrayPush(corpoFactions, "NCPD");

		  if ArrayContains(corpoFactions, ownerFaction){
			ownerCorpo = true;
		  };

		  if ArrayContains(corpoFactions, threatFaction){
			threatCorpo = true;
		  };
		  if Equals(threatFaction, ownerFaction) || (ownerCorpo && threatCorpo){
			threatValue = -1.0;
			
			switch ownerFaction{
				case "Arasaka":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"arasaka");
					break;
				case "Maelstrom":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"maelstrom");
					break;
				case "SixthStreet":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"6thStreet");
					break;
				case "NCPD":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"police");
					break;
				case "TygerClaws":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"tygerClaws");
					break;
				case "Valentinos":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"valentinos");
					break;
				case "VoodooBoys":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"voodooBoys");
					break;
				case "Wraiths":
					threat.GetAttitudeAgent().SetAttitudeGroup(n"wraiths");
					break;
				}
				
			owner.GetAttitudeAgent().SetAttitudeTowards(threat.GetAttitudeAgent(), EAIAttitude.AIA_Friendly);
			threat.GetAttitudeAgent().SetAttitudeTowards(owner.GetAttitudeAgent(), EAIAttitude.AIA_Friendly);
			return;
		  };
		  if threat.IsPuppet() || IsDefined(turret) {
			if threat.IsPlayerControlled() {
			  threatValue = 1.00;
			  
			} else {
			  if IsDefined(turret) {
				threatValue = 1.00;
			  };
			};
			distance = AIActionTarget.GetDistanceToThreat(ownerPos, threat, zDiff, true);
			threatValue += AIActionTarget.GetThreatZDiffModifier(zDiff);
			threatValue += AIActionTarget.GetThreatDistanceModifier(targetTrackerComponent, distance);
			threatValue += AIActionTarget.GetThreatHisteresisModifier(targetTrackerComponent, threat, newTargetObject, timeSinceTargetChange);
			threatValue += AIActionTarget.GetThreatDamageModifier(targetTrackerComponent, owner, threat, distance, currentTime);
			threatValue += AIActionTarget.GetThreatAttackersModifier(targetTrackerComponent, owner, threat);
			threatValue += AIActionTarget.GetThreatLastVisibilityModifier(owner, threat);
			threatValue += AIActionTarget.GetThreatAccessibilityFromCoverModifier(owner, threat);
			if ScriptedPuppet.IsBeingGrappled(threat) {
			  threatValue *= 0.10;
			} else {
			  if !AIActionTarget.HasWeaponInInventory(threat) {
				threatValue *= 0.50;
			  };
			};
		  };
		};
		
		
		

		return;
	}
	else{
		wrappedMethod(owner, ownerPos, targetTrackerComponent, newTargetObject, threat, timeSinceTargetChange, currentTime, threatValue);
	}

  }
  
  
  